unit PhoneClass;

interface

uses sysUtils, dateUtils;

type
  Tphone = class
  private
    brand: string;
    model: string;
    owner: string;
    purchaseDate: TDateTime;
    price: Double;
  public
    constructor create; overload;
    constructor create(brand: string; model: string; owner: string;
      purchaseDate: TDateTime; price: Double); overload;
    function getPrice: Double;
    function getBrand: String;
    function getModel: String;
    function getOwner: String;
    procedure setPrice(price: Double);
    function calculateAge: Integer;
    function toString: string;
  end;

implementation

{ Tphone }

function Tphone.calculateAge: Integer;
  var
    NumDays: Integer;
  begin
    NumDays := round(now - purchaseDate);
    Result := NumDays DIV 365;
  end;

constructor Tphone.create;
  begin

  end;

constructor Tphone.create(brand, model, owner: string; purchaseDate: TDateTime;
  price: Double);
  begin
    Self.brand := brand;
    Self.model := model;
    Self.owner := owner;
    Self.purchaseDate := purchaseDate;
    Self.price := price;
  end;

function Tphone.getOwner: String;
  begin
    Result := owner;
  end;

function Tphone.getBrand: String;
  begin
    Result := brand;
  end;

function Tphone.getModel: String;
  begin
    Result := model;
  end;

function Tphone.getPrice: Double;
  begin
    Result := price;
  end;

procedure Tphone.setPrice(price: Double);
  begin
    Self.price := price;
  end;

function Tphone.toString: string;
  begin
    Result := 'Brand: ' + brand + sLineBreak + 'Model: ' + model + sLineBreak +
      'Owner: ' + owner + sLineBreak + 'Purchase Date: ' + formatdatetime
      ('dddddd', purchaseDate) + sLineBreak + 'Price: ' + Format('R%f',
      [price]);
  end;

end.
